package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServiceConfigurationRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceId: VpcEndpointServiceId,
    privateDnsName: Optional[String] = Optional.Absent,
    removePrivateDnsName: Optional[Boolean] = Optional.Absent,
    acceptanceRequired: Optional[Boolean] = Optional.Absent,
    addNetworkLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    removeNetworkLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    addGatewayLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    removeGatewayLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    addSupportedIpAddressTypes: Optional[Iterable[String]] = Optional.Absent,
    removeSupportedIpAddressTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest = {
    import ModifyVpcEndpointServiceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        removePrivateDnsName.map(value => value: java.lang.Boolean)
      )(_.removePrivateDnsName)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        addNetworkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addNetworkLoadBalancerArns)
      .optionallyWith(
        removeNetworkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeNetworkLoadBalancerArns)
      .optionallyWith(
        addGatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addGatewayLoadBalancerArns)
      .optionallyWith(
        removeGatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeGatewayLoadBalancerArns)
      .optionallyWith(
        addSupportedIpAddressTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addSupportedIpAddressTypes)
      .optionallyWith(
        removeSupportedIpAddressTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeSupportedIpAddressTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServiceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest =
      zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest(
        dryRun.map(value => value),
        serviceId,
        privateDnsName.map(value => value),
        removePrivateDnsName.map(value => value),
        acceptanceRequired.map(value => value),
        addNetworkLoadBalancerArns.map(value => value),
        removeNetworkLoadBalancerArns.map(value => value),
        addGatewayLoadBalancerArns.map(value => value),
        removeGatewayLoadBalancerArns.map(value => value),
        addSupportedIpAddressTypes.map(value => value),
        removeSupportedIpAddressTypes.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def serviceId: VpcEndpointServiceId
    def privateDnsName: Optional[String]
    def removePrivateDnsName: Optional[Boolean]
    def acceptanceRequired: Optional[Boolean]
    def addNetworkLoadBalancerArns: Optional[List[String]]
    def removeNetworkLoadBalancerArns: Optional[List[String]]
    def addGatewayLoadBalancerArns: Optional[List[String]]
    def removeGatewayLoadBalancerArns: Optional[List[String]]
    def addSupportedIpAddressTypes: Optional[List[String]]
    def removeSupportedIpAddressTypes: Optional[List[String]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getRemovePrivateDnsName: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removePrivateDnsName", removePrivateDnsName)
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getAddNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addNetworkLoadBalancerArns",
        addNetworkLoadBalancerArns
      )
    def getRemoveNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeNetworkLoadBalancerArns",
        removeNetworkLoadBalancerArns
      )
    def getAddGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addGatewayLoadBalancerArns",
        addGatewayLoadBalancerArns
      )
    def getRemoveGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeGatewayLoadBalancerArns",
        removeGatewayLoadBalancerArns
      )
    def getAddSupportedIpAddressTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addSupportedIpAddressTypes",
        addSupportedIpAddressTypes
      )
    def getRemoveSupportedIpAddressTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeSupportedIpAddressTypes",
        removeSupportedIpAddressTypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val removePrivateDnsName: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removePrivateDnsName())
      .map(value => value: Boolean)
    override val acceptanceRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceRequired())
      .map(value => value: Boolean)
    override val addNetworkLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addNetworkLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val removeNetworkLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeNetworkLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val addGatewayLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addGatewayLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val removeGatewayLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeGatewayLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val addSupportedIpAddressTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addSupportedIpAddressTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val removeSupportedIpAddressTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSupportedIpAddressTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
