package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVolumeAttributeRequest(
    autoEnableIO: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    volumeId: VolumeId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest = {
    import ModifyVolumeAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
      .builder()
      .optionallyWith(autoEnableIO.map(value => value.buildAwsValue()))(
        _.autoEnableIO
      )
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVolumeAttributeRequest.wrap(buildAwsValue())
}
object ModifyVolumeAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVolumeAttributeRequest =
      zio.aws.ec2.model.ModifyVolumeAttributeRequest(
        autoEnableIO.map(value => value.asEditable),
        volumeId,
        dryRun.map(value => value)
      )
    def autoEnableIO: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def volumeId: VolumeId
    def dryRun: Optional[Boolean]
    def getAutoEnableIO
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("autoEnableIO", autoEnableIO)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ) extends zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly {
    override val autoEnableIO
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoEnableIO())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest
  ): zio.aws.ec2.model.ModifyVolumeAttributeRequest.ReadOnly = new Wrapper(impl)
}
