package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessTrustProviderId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessTrustProviderRequest(
    verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId,
    oidcOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest = {
    import ModifyVerifiedAccessTrustProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest
      .builder()
      .verifiedAccessTrustProviderId(
        VerifiedAccessTrustProviderId.unwrap(
          verifiedAccessTrustProviderId
        ): java.lang.String
      )
      .optionallyWith(oidcOptions.map(value => value.buildAwsValue()))(
        _.oidcOptions
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessTrustProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest(
        verifiedAccessTrustProviderId,
        oidcOptions.map(value => value.asEditable),
        description.map(value => value),
        dryRun.map(value => value),
        clientToken.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId
    def oidcOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ]
    def description: Optional[String]
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ]
    def getVerifiedAccessTrustProviderId
        : ZIO[Any, Nothing, VerifiedAccessTrustProviderId] =
      ZIO.succeed(verifiedAccessTrustProviderId)
    def getOidcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ] = AwsError.unwrapOptionField("oidcOptions", oidcOptions)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest.ReadOnly {
    override val verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessTrustProviderId(impl.verifiedAccessTrustProviderId())
    override val oidcOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oidcOptions())
      .map(value =>
        zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
          .wrap(value)
      )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderRequest.ReadOnly =
    new Wrapper(impl)
}
