package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VerifiedAccessGroupId,
  VerifiedAccessEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId,
    verifiedAccessGroupId: Optional[VerifiedAccessGroupId] = Optional.Absent,
    loadBalancerOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
    ] = Optional.Absent,
    networkInterfaceOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest = {
    import ModifyVerifiedAccessEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .optionallyWith(
        verifiedAccessGroupId.map(value =>
          VerifiedAccessGroupId.unwrap(value): java.lang.String
        )
      )(_.verifiedAccessGroupId)
      .optionallyWith(loadBalancerOptions.map(value => value.buildAwsValue()))(
        _.loadBalancerOptions
      )
      .optionallyWith(
        networkInterfaceOptions.map(value => value.buildAwsValue())
      )(_.networkInterfaceOptions)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest.wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest(
        verifiedAccessEndpointId,
        verifiedAccessGroupId.map(value => value),
        loadBalancerOptions.map(value => value.asEditable),
        networkInterfaceOptions.map(value => value.asEditable),
        description.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def verifiedAccessGroupId: Optional[VerifiedAccessGroupId]
    def loadBalancerOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ]
    def networkInterfaceOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly
    ]
    def description: Optional[String]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
    def getVerifiedAccessGroupId: ZIO[Any, AwsError, VerifiedAccessGroupId] =
      AwsError.unwrapOptionField("verifiedAccessGroupId", verifiedAccessGroupId)
    def getLoadBalancerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerOptions", loadBalancerOptions)
    def getNetworkInterfaceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInterfaceOptions",
      networkInterfaceOptions
    )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
    override val verifiedAccessGroupId: Optional[VerifiedAccessGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroupId())
        .map(value => zio.aws.ec2.model.primitives.VerifiedAccessGroupId(value))
    override val loadBalancerOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerOptions())
      .map(value =>
        zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
          .wrap(value)
      )
    override val networkInterfaceOptions: Optional[
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceOptions())
      .map(value =>
        zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.wrap(value)
      )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
