package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointPolicyResponse(
    policyEnabled: Optional[Boolean] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse = {
    import ModifyVerifiedAccessEndpointPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse
      .builder()
      .optionallyWith(policyEnabled.map(value => value: java.lang.Boolean))(
        _.policyEnabled
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse(
        policyEnabled.map(value => value),
        policyDocument.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def policyEnabled: Optional[Boolean]
    def policyDocument: Optional[String]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ]
    def getPolicyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("policyEnabled", policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse.ReadOnly {
    override val policyEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.policyEnabled())
      .map(value => value: Boolean)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
