package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceMaintenanceOptionsRequest(
    instanceId: InstanceId,
    autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest = {
    import ModifyInstanceMaintenanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest
      .wrap(buildAwsValue())
}
object ModifyInstanceMaintenanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest =
      zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest(
        instanceId,
        autoRecovery.map(value => value),
        dryRun.map(value => value)
      )
    def instanceId: InstanceId
    def autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState]
    def dryRun: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAutoRecovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAutoRecoveryState] =
      AwsError.unwrapOptionField("autoRecovery", autoRecovery)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest
  ) extends zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val autoRecovery
        : Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRecovery())
        .map(value => zio.aws.ec2.model.InstanceAutoRecoveryState.wrap(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest
  ): zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
