package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  InstanceEventWindowCronExpression,
  InstanceEventWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceEventWindowRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    instanceEventWindowId: InstanceEventWindowId,
    timeRanges: Optional[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest]
    ] = Optional.Absent,
    cronExpression: Optional[InstanceEventWindowCronExpression] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest = {
    import ModifyInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceEventWindowRequest.wrap(buildAwsValue())
}
object ModifyInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceEventWindowRequest =
      zio.aws.ec2.model.ModifyInstanceEventWindowRequest(
        dryRun.map(value => value),
        name.map(value => value),
        instanceEventWindowId,
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cronExpression.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def name: Optional[String]
    def instanceEventWindowId: InstanceEventWindowId
    def timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ]
    def cronExpression: Optional[InstanceEventWindowCronExpression]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val timeRanges: Optional[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.wrap(item)
        }.toList
      )
    override val cronExpression: Optional[InstanceEventWindowCronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ): zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
