package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DedicatedHostId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyHostsRequest(
    autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] = Optional.Absent,
    hostIds: Iterable[DedicatedHostId],
    hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    instanceFamily: Optional[String] = Optional.Absent,
    hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyHostsRequest = {
    import ModifyHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .hostIds(hostIds.map { item =>
        DedicatedHostId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(hostMaintenance.map(value => value.unwrap))(
        _.hostMaintenance
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyHostsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyHostsRequest.wrap(buildAwsValue())
}
object ModifyHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyHostsRequest =
      zio.aws.ec2.model.ModifyHostsRequest(
        autoPlacement.map(value => value),
        hostIds,
        hostRecovery.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value),
        hostMaintenance.map(value => value)
      )
    def autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement]
    def hostIds: List[DedicatedHostId]
    def hostRecovery: Optional[zio.aws.ec2.model.HostRecovery]
    def instanceType: Optional[String]
    def instanceFamily: Optional[String]
    def hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getHostIds: ZIO[Any, Nothing, List[DedicatedHostId]] =
      ZIO.succeed(hostIds)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getHostMaintenance
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostMaintenance] =
      AwsError.unwrapOptionField("hostMaintenance", hostMaintenance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ) extends zio.aws.ec2.model.ModifyHostsRequest.ReadOnly {
    override val autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoPlacement())
        .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val hostIds: List[DedicatedHostId] = impl
      .hostIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.DedicatedHostId(item)
      }
      .toList
    override val hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostRecovery())
        .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val instanceFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamily())
      .map(value => value: String)
    override val hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostMaintenance())
        .map(value => zio.aws.ec2.model.HostMaintenance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsRequest
  ): zio.aws.ec2.model.ModifyHostsRequest.ReadOnly = new Wrapper(impl)
}
