package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateErrorCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode
}
object LaunchTemplateErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode
  ): zio.aws.ec2.model.LaunchTemplateErrorCode = value match {
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST =>
      val r = launchTemplateIdDoesNotExist
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_ID_MALFORMED =>
      val r = launchTemplateIdMalformed
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST =>
      val r = launchTemplateNameDoesNotExist
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_NAME_MALFORMED =>
      val r = launchTemplateNameMalformed
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST =>
      val r = launchTemplateVersionDoesNotExist
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.UNEXPECTED_ERROR =>
      val r = unexpectedError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object launchTemplateIdDoesNotExist
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST
  }
  case object launchTemplateIdMalformed
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_ID_MALFORMED
  }
  case object launchTemplateNameDoesNotExist
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST
  }
  case object launchTemplateNameMalformed
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_NAME_MALFORMED
  }
  case object launchTemplateVersionDoesNotExist
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST
  }
  case object unexpectedError
      extends zio.aws.ec2.model.LaunchTemplateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateErrorCode.UNEXPECTED_ERROR
  }
}
