package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceAutoRecoveryState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState
}
object InstanceAutoRecoveryState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState
  ): zio.aws.ec2.model.InstanceAutoRecoveryState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.DEFAULT =>
      val r = default
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.ec2.model.InstanceAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.DISABLED
  }
  case object default extends zio.aws.ec2.model.InstanceAutoRecoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState =
      software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState.DEFAULT
  }
}
