package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class Instance(
    amiLaunchIndex: Optional[Integer] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    kernelId: Optional[String] = Optional.Absent,
    keyName: Optional[String] = Optional.Absent,
    launchTime: Optional[DateTime] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.Monitoring] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.Placement] = Optional.Absent,
    platform: Optional[zio.aws.ec2.model.PlatformValues] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent,
    publicDnsName: Optional[String] = Optional.Absent,
    publicIpAddress: Optional[String] = Optional.Absent,
    ramdiskId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.InstanceState] = Optional.Absent,
    stateTransitionReason: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMapping]
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    enaSupport: Optional[Boolean] = Optional.Absent,
    hypervisor: Optional[zio.aws.ec2.model.HypervisorType] = Optional.Absent,
    iamInstanceProfile: Optional[zio.aws.ec2.model.IamInstanceProfile] =
      Optional.Absent,
    instanceLifecycle: Optional[zio.aws.ec2.model.InstanceLifecycleType] =
      Optional.Absent,
    elasticGpuAssociations: Optional[
      Iterable[zio.aws.ec2.model.ElasticGpuAssociation]
    ] = Optional.Absent,
    elasticInferenceAcceleratorAssociations: Optional[
      Iterable[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation]
    ] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterface]
    ] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    rootDeviceName: Optional[String] = Optional.Absent,
    rootDeviceType: Optional[zio.aws.ec2.model.DeviceType] = Optional.Absent,
    securityGroups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    sourceDestCheck: Optional[Boolean] = Optional.Absent,
    spotInstanceRequestId: Optional[String] = Optional.Absent,
    sriovNetSupport: Optional[String] = Optional.Absent,
    stateReason: Optional[zio.aws.ec2.model.StateReason] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    virtualizationType: Optional[zio.aws.ec2.model.VirtualizationType] =
      Optional.Absent,
    cpuOptions: Optional[zio.aws.ec2.model.CpuOptions] = Optional.Absent,
    capacityReservationId: Optional[String] = Optional.Absent,
    capacityReservationSpecification: Optional[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse
    ] = Optional.Absent,
    hibernationOptions: Optional[zio.aws.ec2.model.HibernationOptions] =
      Optional.Absent,
    licenses: Optional[Iterable[zio.aws.ec2.model.LicenseConfiguration]] =
      Optional.Absent,
    metadataOptions: Optional[
      zio.aws.ec2.model.InstanceMetadataOptionsResponse
    ] = Optional.Absent,
    enclaveOptions: Optional[zio.aws.ec2.model.EnclaveOptions] =
      Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.BootModeValues] = Optional.Absent,
    platformDetails: Optional[String] = Optional.Absent,
    usageOperation: Optional[String] = Optional.Absent,
    usageOperationUpdateTime: Optional[MillisecondDateTime] = Optional.Absent,
    privateDnsNameOptions: Optional[
      zio.aws.ec2.model.PrivateDnsNameOptionsResponse
    ] = Optional.Absent,
    ipv6Address: Optional[String] = Optional.Absent,
    tpmSupport: Optional[String] = Optional.Absent,
    maintenanceOptions: Optional[zio.aws.ec2.model.InstanceMaintenanceOptions] =
      Optional.Absent,
    currentInstanceBootMode: Optional[
      zio.aws.ec2.model.InstanceBootModeValues
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Instance
      .builder()
      .optionallyWith(amiLaunchIndex.map(value => value: java.lang.Integer))(
        _.amiLaunchIndex
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(launchTime.map(value => DateTime.unwrap(value): Instant))(
        _.launchTime
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(instanceLifecycle.map(value => value.unwrap))(
        _.instanceLifecycle
      )
      .optionallyWith(
        elasticGpuAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuAssociations)
      .optionallyWith(
        elasticInferenceAcceleratorAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAcceleratorAssociations)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(rootDeviceType.map(value => value.unwrap))(
        _.rootDeviceType
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(virtualizationType.map(value => value.unwrap))(
        _.virtualizationType
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(
        licenses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenses)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(platformDetails.map(value => value: java.lang.String))(
        _.platformDetails
      )
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(
        usageOperationUpdateTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.usageOperationUpdateTime)
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .optionallyWith(tpmSupport.map(value => value: java.lang.String))(
        _.tpmSupport
      )
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .optionallyWith(currentInstanceBootMode.map(value => value.unwrap))(
        _.currentInstanceBootMode
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Instance.ReadOnly =
    zio.aws.ec2.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Instance = zio.aws.ec2.model.Instance(
      amiLaunchIndex.map(value => value),
      imageId.map(value => value),
      instanceId.map(value => value),
      instanceType.map(value => value),
      kernelId.map(value => value),
      keyName.map(value => value),
      launchTime.map(value => value),
      monitoring.map(value => value.asEditable),
      placement.map(value => value.asEditable),
      platform.map(value => value),
      privateDnsName.map(value => value),
      privateIpAddress.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      publicDnsName.map(value => value),
      publicIpAddress.map(value => value),
      ramdiskId.map(value => value),
      state.map(value => value.asEditable),
      stateTransitionReason.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      architecture.map(value => value),
      blockDeviceMappings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      clientToken.map(value => value),
      ebsOptimized.map(value => value),
      enaSupport.map(value => value),
      hypervisor.map(value => value),
      iamInstanceProfile.map(value => value.asEditable),
      instanceLifecycle.map(value => value),
      elasticGpuAssociations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      elasticInferenceAcceleratorAssociations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkInterfaces.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      outpostArn.map(value => value),
      rootDeviceName.map(value => value),
      rootDeviceType.map(value => value),
      securityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      sourceDestCheck.map(value => value),
      spotInstanceRequestId.map(value => value),
      sriovNetSupport.map(value => value),
      stateReason.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      virtualizationType.map(value => value),
      cpuOptions.map(value => value.asEditable),
      capacityReservationId.map(value => value),
      capacityReservationSpecification.map(value => value.asEditable),
      hibernationOptions.map(value => value.asEditable),
      licenses.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      metadataOptions.map(value => value.asEditable),
      enclaveOptions.map(value => value.asEditable),
      bootMode.map(value => value),
      platformDetails.map(value => value),
      usageOperation.map(value => value),
      usageOperationUpdateTime.map(value => value),
      privateDnsNameOptions.map(value => value.asEditable),
      ipv6Address.map(value => value),
      tpmSupport.map(value => value),
      maintenanceOptions.map(value => value.asEditable),
      currentInstanceBootMode.map(value => value)
    )
    def amiLaunchIndex: Optional[Integer]
    def imageId: Optional[String]
    def instanceId: Optional[String]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def kernelId: Optional[String]
    def keyName: Optional[String]
    def launchTime: Optional[DateTime]
    def monitoring: Optional[zio.aws.ec2.model.Monitoring.ReadOnly]
    def placement: Optional[zio.aws.ec2.model.Placement.ReadOnly]
    def platform: Optional[zio.aws.ec2.model.PlatformValues]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def publicDnsName: Optional[String]
    def publicIpAddress: Optional[String]
    def ramdiskId: Optional[String]
    def state: Optional[zio.aws.ec2.model.InstanceState.ReadOnly]
    def stateTransitionReason: Optional[String]
    def subnetId: Optional[String]
    def vpcId: Optional[String]
    def architecture: Optional[zio.aws.ec2.model.ArchitectureValues]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]]
    def clientToken: Optional[String]
    def ebsOptimized: Optional[Boolean]
    def enaSupport: Optional[Boolean]
    def hypervisor: Optional[zio.aws.ec2.model.HypervisorType]
    def iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfile.ReadOnly]
    def instanceLifecycle: Optional[zio.aws.ec2.model.InstanceLifecycleType]
    def elasticGpuAssociations
        : Optional[List[zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly]]
    def elasticInferenceAcceleratorAssociations: Optional[
      List[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly]
    ]
    def networkInterfaces
        : Optional[List[zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly]]
    def outpostArn: Optional[String]
    def rootDeviceName: Optional[String]
    def rootDeviceType: Optional[zio.aws.ec2.model.DeviceType]
    def securityGroups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def sourceDestCheck: Optional[Boolean]
    def spotInstanceRequestId: Optional[String]
    def sriovNetSupport: Optional[String]
    def stateReason: Optional[zio.aws.ec2.model.StateReason.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def virtualizationType: Optional[zio.aws.ec2.model.VirtualizationType]
    def cpuOptions: Optional[zio.aws.ec2.model.CpuOptions.ReadOnly]
    def capacityReservationId: Optional[String]
    def capacityReservationSpecification: Optional[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ]
    def hibernationOptions
        : Optional[zio.aws.ec2.model.HibernationOptions.ReadOnly]
    def licenses
        : Optional[List[zio.aws.ec2.model.LicenseConfiguration.ReadOnly]]
    def metadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly]
    def enclaveOptions: Optional[zio.aws.ec2.model.EnclaveOptions.ReadOnly]
    def bootMode: Optional[zio.aws.ec2.model.BootModeValues]
    def platformDetails: Optional[String]
    def usageOperation: Optional[String]
    def usageOperationUpdateTime: Optional[MillisecondDateTime]
    def privateDnsNameOptions
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly]
    def ipv6Address: Optional[String]
    def tpmSupport: Optional[String]
    def maintenanceOptions
        : Optional[zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly]
    def currentInstanceBootMode
        : Optional[zio.aws.ec2.model.InstanceBootModeValues]
    def getAmiLaunchIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("amiLaunchIndex", amiLaunchIndex)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getLaunchTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("launchTime", launchTime)
    def getMonitoring
        : ZIO[Any, AwsError, zio.aws.ec2.model.Monitoring.ReadOnly] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getHypervisor: ZIO[Any, AwsError, zio.aws.ec2.model.HypervisorType] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getIamInstanceProfile
        : ZIO[Any, AwsError, zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getInstanceLifecycle
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceLifecycleType] =
      AwsError.unwrapOptionField("instanceLifecycle", instanceLifecycle)
    def getElasticGpuAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuAssociations",
      elasticGpuAssociations
    )
    def getElasticInferenceAcceleratorAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociations",
      elasticInferenceAcceleratorAssociations
    )
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getRootDeviceType: ZIO[Any, AwsError, zio.aws.ec2.model.DeviceType] =
      AwsError.unwrapOptionField("rootDeviceType", rootDeviceType)
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getStateReason
        : ZIO[Any, AwsError, zio.aws.ec2.model.StateReason.ReadOnly] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualizationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VirtualizationType] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getCpuOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.CpuOptions.ReadOnly] =
      AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getHibernationOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.HibernationOptions.ReadOnly] =
      AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getLicenses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LicenseConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("licenses", licenses)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getPlatformDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformDetails", platformDetails)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getUsageOperationUpdateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "usageOperationUpdateTime",
        usageOperationUpdateTime
      )
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
    def getTpmSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tpmSupport", tpmSupport)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
    def getCurrentInstanceBootMode
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceBootModeValues] =
      AwsError.unwrapOptionField(
        "currentInstanceBootMode",
        currentInstanceBootMode
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Instance
  ) extends zio.aws.ec2.model.Instance.ReadOnly {
    override val amiLaunchIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.amiLaunchIndex())
      .map(value => value: Integer)
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => value: String)
    override val keyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => value: String)
    override val launchTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val monitoring: Optional[zio.aws.ec2.model.Monitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value => zio.aws.ec2.model.Monitoring.wrap(value))
    override val placement: Optional[zio.aws.ec2.model.Placement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val platform: Optional[zio.aws.ec2.model.PlatformValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
    override val publicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => value: String)
    override val publicIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpAddress())
      .map(value => value: String)
    override val ramdiskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val stateTransitionReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateTransitionReason())
      .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val enaSupport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSupport())
      .map(value => value: Boolean)
    override val hypervisor: Optional[zio.aws.ec2.model.HypervisorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hypervisor())
        .map(value => zio.aws.ec2.model.HypervisorType.wrap(value))
    override val iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value => zio.aws.ec2.model.IamInstanceProfile.wrap(value))
    override val instanceLifecycle
        : Optional[zio.aws.ec2.model.InstanceLifecycleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceLifecycle())
        .map(value => zio.aws.ec2.model.InstanceLifecycleType.wrap(value))
    override val elasticGpuAssociations
        : Optional[List[zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpuAssociation.wrap(item)
          }.toList
        )
    override val elasticInferenceAcceleratorAssociations: Optional[
      List[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAcceleratorAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.wrap(item)
        }.toList
      )
    override val networkInterfaces
        : Optional[List[zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceNetworkInterface.wrap(item)
          }.toList
        )
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val rootDeviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDeviceName())
      .map(value => value: String)
    override val rootDeviceType: Optional[zio.aws.ec2.model.DeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootDeviceType())
        .map(value => zio.aws.ec2.model.DeviceType.wrap(value))
    override val securityGroups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val sourceDestCheck: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDestCheck())
      .map(value => value: Boolean)
    override val spotInstanceRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotInstanceRequestId())
      .map(value => value: String)
    override val sriovNetSupport: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sriovNetSupport())
      .map(value => value: String)
    override val stateReason: Optional[zio.aws.ec2.model.StateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value => zio.aws.ec2.model.StateReason.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val virtualizationType
        : Optional[zio.aws.ec2.model.VirtualizationType] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualizationType())
      .map(value => zio.aws.ec2.model.VirtualizationType.wrap(value))
    override val cpuOptions: Optional[zio.aws.ec2.model.CpuOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuOptions())
        .map(value => zio.aws.ec2.model.CpuOptions.wrap(value))
    override val capacityReservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationId())
      .map(value => value: String)
    override val capacityReservationSpecification: Optional[
      zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationSpecificationResponse.wrap(value)
      )
    override val hibernationOptions
        : Optional[zio.aws.ec2.model.HibernationOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hibernationOptions())
        .map(value => zio.aws.ec2.model.HibernationOptions.wrap(value))
    override val licenses
        : Optional[List[zio.aws.ec2.model.LicenseConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LicenseConfiguration.wrap(item)
          }.toList
        )
    override val metadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsResponse.wrap(value)
        )
    override val enclaveOptions
        : Optional[zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enclaveOptions())
        .map(value => zio.aws.ec2.model.EnclaveOptions.wrap(value))
    override val bootMode: Optional[zio.aws.ec2.model.BootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
    override val platformDetails: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformDetails())
      .map(value => value: String)
    override val usageOperation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageOperation())
      .map(value => value: String)
    override val usageOperationUpdateTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageOperationUpdateTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val privateDnsNameOptions
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsNameOptions())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsResponse.wrap(value)
        )
    override val ipv6Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => value: String)
    override val tpmSupport: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tpmSupport())
      .map(value => value: String)
    override val maintenanceOptions
        : Optional[zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceOptions())
        .map(value => zio.aws.ec2.model.InstanceMaintenanceOptions.wrap(value))
    override val currentInstanceBootMode
        : Optional[zio.aws.ec2.model.InstanceBootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInstanceBootMode())
        .map(value => zio.aws.ec2.model.InstanceBootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Instance
  ): zio.aws.ec2.model.Instance.ReadOnly = new Wrapper(impl)
}
