package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.TotalInferenceMemory
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InferenceAcceleratorInfo(
    accelerators: Optional[Iterable[zio.aws.ec2.model.InferenceDeviceInfo]] =
      Optional.Absent,
    totalInferenceMemoryInMiB: Optional[TotalInferenceMemory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo = {
    import InferenceAcceleratorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
      .builder()
      .optionallyWith(
        accelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accelerators)
      .optionallyWith(
        totalInferenceMemoryInMiB.map(value =>
          TotalInferenceMemory.unwrap(value): Integer
        )
      )(_.totalInferenceMemoryInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly =
    zio.aws.ec2.model.InferenceAcceleratorInfo.wrap(buildAwsValue())
}
object InferenceAcceleratorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InferenceAcceleratorInfo =
      zio.aws.ec2.model.InferenceAcceleratorInfo(
        accelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalInferenceMemoryInMiB.map(value => value)
      )
    def accelerators
        : Optional[List[zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly]]
    def totalInferenceMemoryInMiB: Optional[TotalInferenceMemory]
    def getAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("accelerators", accelerators)
    def getTotalInferenceMemoryInMiB: ZIO[Any, AwsError, TotalInferenceMemory] =
      AwsError.unwrapOptionField(
        "totalInferenceMemoryInMiB",
        totalInferenceMemoryInMiB
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ) extends zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly {
    override val accelerators
        : Optional[List[zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InferenceDeviceInfo.wrap(item)
          }.toList
        )
    override val totalInferenceMemoryInMiB: Optional[TotalInferenceMemory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalInferenceMemoryInMiB())
        .map(value => zio.aws.ec2.model.primitives.TotalInferenceMemory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo
  ): zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly = new Wrapper(impl)
}
