package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportSnapshotRequest(
    clientData: Optional[zio.aws.ec2.model.ClientData] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    diskContainer: Optional[zio.aws.ec2.model.SnapshotDiskContainer] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    roleName: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest = {
    import ImportSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
      .builder()
      .optionallyWith(clientData.map(value => value.buildAwsValue()))(
        _.clientData
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(diskContainer.map(value => value.buildAwsValue()))(
        _.diskContainer
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly =
    zio.aws.ec2.model.ImportSnapshotRequest.wrap(buildAwsValue())
}
object ImportSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportSnapshotRequest =
      zio.aws.ec2.model.ImportSnapshotRequest(
        clientData.map(value => value.asEditable),
        clientToken.map(value => value),
        description.map(value => value),
        diskContainer.map(value => value.asEditable),
        dryRun.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        roleName.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientData: Optional[zio.aws.ec2.model.ClientData.ReadOnly]
    def clientToken: Optional[String]
    def description: Optional[String]
    def diskContainer
        : Optional[zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly]
    def dryRun: Optional[Boolean]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[KmsKeyId]
    def roleName: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientData
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientData.ReadOnly] =
      AwsError.unwrapOptionField("clientData", clientData)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskContainer
        : ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly] =
      AwsError.unwrapOptionField("diskContainer", diskContainer)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ) extends zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly {
    override val clientData: Optional[zio.aws.ec2.model.ClientData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientData())
        .map(value => zio.aws.ec2.model.ClientData.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val diskContainer
        : Optional[zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskContainer())
        .map(value => zio.aws.ec2.model.SnapshotDiskContainer.wrap(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val roleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest
  ): zio.aws.ec2.model.ImportSnapshotRequest.ReadOnly = new Wrapper(impl)
}
