package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportInstanceResponse(
    conversionTask: Optional[zio.aws.ec2.model.ConversionTask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceResponse = {
    import ImportInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceResponse
      .builder()
      .optionallyWith(conversionTask.map(value => value.buildAwsValue()))(
        _.conversionTask
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceResponse.ReadOnly =
    zio.aws.ec2.model.ImportInstanceResponse.wrap(buildAwsValue())
}
object ImportInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceResponse = zio.aws.ec2.model
      .ImportInstanceResponse(conversionTask.map(value => value.asEditable))
    def conversionTask: Optional[zio.aws.ec2.model.ConversionTask.ReadOnly]
    def getConversionTask
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConversionTask.ReadOnly] =
      AwsError.unwrapOptionField("conversionTask", conversionTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceResponse
  ) extends zio.aws.ec2.model.ImportInstanceResponse.ReadOnly {
    override val conversionTask
        : Optional[zio.aws.ec2.model.ConversionTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversionTask())
        .map(value => zio.aws.ec2.model.ConversionTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceResponse
  ): zio.aws.ec2.model.ImportInstanceResponse.ReadOnly = new Wrapper(impl)
}
