package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportClientVpnClientCertificateRevocationListRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    certificateRevocationList: String,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest = {
    import ImportClientVpnClientCertificateRevocationListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .certificateRevocationList(certificateRevocationList: java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
      .wrap(buildAwsValue())
}
object ImportClientVpnClientCertificateRevocationListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest =
      zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest(
        clientVpnEndpointId,
        certificateRevocationList,
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def certificateRevocationList: String
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getCertificateRevocationList: ZIO[Any, Nothing, String] =
      ZIO.succeed(certificateRevocationList)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ) extends zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val certificateRevocationList: String =
      impl.certificateRevocationList(): String
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ): zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest.ReadOnly =
    new Wrapper(impl)
}
