package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HostMaintenance {
  def unwrap: software.amazon.awssdk.services.ec2.model.HostMaintenance
}
object HostMaintenance {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HostMaintenance
  ): zio.aws.ec2.model.HostMaintenance = value match {
    case software.amazon.awssdk.services.ec2.model.HostMaintenance.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HostMaintenance.ON =>
      val r = on
      r
    case software.amazon.awssdk.services.ec2.model.HostMaintenance.OFF =>
      val r = off
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HostMaintenance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostMaintenance =
      software.amazon.awssdk.services.ec2.model.HostMaintenance.UNKNOWN_TO_SDK_VERSION
  }
  case object on extends zio.aws.ec2.model.HostMaintenance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostMaintenance =
      software.amazon.awssdk.services.ec2.model.HostMaintenance.ON
  }
  case object off extends zio.aws.ec2.model.HostMaintenance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostMaintenance =
      software.amazon.awssdk.services.ec2.model.HostMaintenance.OFF
  }
}
