package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  GetSecurityGroupsForVpcRequestMaxResults,
  VpcId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetSecurityGroupsForVpcRequest(
    vpcId: VpcId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[GetSecurityGroupsForVpcRequestMaxResults] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest = {
    import GetSecurityGroupsForVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          GetSecurityGroupsForVpcRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSecurityGroupsForVpcRequest.ReadOnly =
    zio.aws.ec2.model.GetSecurityGroupsForVpcRequest.wrap(buildAwsValue())
}
object GetSecurityGroupsForVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSecurityGroupsForVpcRequest =
      zio.aws.ec2.model.GetSecurityGroupsForVpcRequest(
        vpcId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def vpcId: VpcId
    def nextToken: Optional[String]
    def maxResults: Optional[GetSecurityGroupsForVpcRequestMaxResults]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, GetSecurityGroupsForVpcRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest
  ) extends zio.aws.ec2.model.GetSecurityGroupsForVpcRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[GetSecurityGroupsForVpcRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .GetSecurityGroupsForVpcRequestMaxResults(value)
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest
  ): zio.aws.ec2.model.GetSecurityGroupsForVpcRequest.ReadOnly = new Wrapper(
    impl
  )
}
