package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetNetworkInsightsAccessScopeContentRequest(
    networkInsightsAccessScopeId: NetworkInsightsAccessScopeId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest = {
    import GetNetworkInsightsAccessScopeContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest
      .builder()
      .networkInsightsAccessScopeId(
        NetworkInsightsAccessScopeId.unwrap(
          networkInsightsAccessScopeId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest.ReadOnly =
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest
      .wrap(buildAwsValue())
}
object GetNetworkInsightsAccessScopeContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest =
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest(
        networkInsightsAccessScopeId,
        dryRun.map(value => value)
      )
    def networkInsightsAccessScopeId: NetworkInsightsAccessScopeId
    def dryRun: Optional[Boolean]
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeId] =
      ZIO.succeed(networkInsightsAccessScopeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest
  ) extends zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest.ReadOnly {
    override val networkInsightsAccessScopeId: NetworkInsightsAccessScopeId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsAccessScopeId(impl.networkInsightsAccessScopeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest
  ): zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest.ReadOnly =
    new Wrapper(impl)
}
