package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{NextToken, IpamMaxResults, IpamPoolId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamPoolCidrsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamPoolId: IpamPoolId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[IpamMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest = {
    import GetIpamPoolCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => IpamMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamPoolCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamPoolCidrsRequest.wrap(buildAwsValue())
}
object GetIpamPoolCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamPoolCidrsRequest =
      zio.aws.ec2.model.GetIpamPoolCidrsRequest(
        dryRun.map(value => value),
        ipamPoolId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def ipamPoolId: IpamPoolId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[IpamMaxResults]
    def nextToken: Optional[NextToken]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, IpamMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest
  ) extends zio.aws.ec2.model.GetIpamPoolCidrsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[IpamMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.IpamMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest
  ): zio.aws.ec2.model.GetIpamPoolCidrsRequest.ReadOnly = new Wrapper(impl)
}
