package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceUefiDataRequest(
    instanceId: InstanceId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest = {
    import GetInstanceUefiDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly =
    zio.aws.ec2.model.GetInstanceUefiDataRequest.wrap(buildAwsValue())
}
object GetInstanceUefiDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetInstanceUefiDataRequest =
      zio.aws.ec2.model
        .GetInstanceUefiDataRequest(instanceId, dryRun.map(value => value))
    def instanceId: InstanceId
    def dryRun: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ) extends zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ): zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly = new Wrapper(impl)
}
