package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FastLaunchSnapshotConfigurationResponse(
    targetResourceCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse = {
    import FastLaunchSnapshotConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse
      .builder()
      .optionallyWith(
        targetResourceCount.map(value => value: java.lang.Integer)
      )(_.targetResourceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse
      .wrap(buildAwsValue())
}
object FastLaunchSnapshotConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse =
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse(
        targetResourceCount.map(value => value)
      )
    def targetResourceCount: Optional[Integer]
    def getTargetResourceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetResourceCount", targetResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse
  ) extends zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly {
    override val targetResourceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetResourceCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse
  ): zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
