package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableVolumeIoRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    volumeId: VolumeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest = {
    import EnableVolumeIoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly =
    zio.aws.ec2.model.EnableVolumeIoRequest.wrap(buildAwsValue())
}
object EnableVolumeIoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableVolumeIoRequest = zio.aws.ec2.model
      .EnableVolumeIoRequest(dryRun.map(value => value), volumeId)
    def dryRun: Optional[Boolean]
    def volumeId: VolumeId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ) extends zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ): zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly = new Wrapper(impl)
}
