package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, ImageId}
import scala.jdk.CollectionConverters._
final case class EnableImageDeprecationRequest(
    imageId: ImageId,
    deprecateAt: MillisecondDateTime,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest = {
    import EnableImageDeprecationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .deprecateAt(MillisecondDateTime.unwrap(deprecateAt): Instant)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly =
    zio.aws.ec2.model.EnableImageDeprecationRequest.wrap(buildAwsValue())
}
object EnableImageDeprecationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableImageDeprecationRequest =
      zio.aws.ec2.model.EnableImageDeprecationRequest(
        imageId,
        deprecateAt,
        dryRun.map(value => value)
      )
    def imageId: ImageId
    def deprecateAt: MillisecondDateTime
    def dryRun: Optional[Boolean]
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getDeprecateAt: ZIO[Any, Nothing, MillisecondDateTime] =
      ZIO.succeed(deprecateAt)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ) extends zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val deprecateAt: MillisecondDateTime =
      zio.aws.ec2.model.primitives.MillisecondDateTime(impl.deprecateAt())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ): zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly = new Wrapper(
    impl
  )
}
