package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableImageBlockPublicAccessResponse(
    imageBlockPublicAccessState: Optional[
      zio.aws.ec2.model.ImageBlockPublicAccessEnabledState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse = {
    import EnableImageBlockPublicAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse
      .builder()
      .optionallyWith(imageBlockPublicAccessState.map(value => value.unwrap))(
        _.imageBlockPublicAccessState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableImageBlockPublicAccessResponse.ReadOnly =
    zio.aws.ec2.model.EnableImageBlockPublicAccessResponse.wrap(buildAwsValue())
}
object EnableImageBlockPublicAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableImageBlockPublicAccessResponse =
      zio.aws.ec2.model.EnableImageBlockPublicAccessResponse(
        imageBlockPublicAccessState.map(value => value)
      )
    def imageBlockPublicAccessState
        : Optional[zio.aws.ec2.model.ImageBlockPublicAccessEnabledState]
    def getImageBlockPublicAccessState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImageBlockPublicAccessEnabledState
    ] = AwsError.unwrapOptionField(
      "imageBlockPublicAccessState",
      imageBlockPublicAccessState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse
  ) extends zio.aws.ec2.model.EnableImageBlockPublicAccessResponse.ReadOnly {
    override val imageBlockPublicAccessState
        : Optional[zio.aws.ec2.model.ImageBlockPublicAccessEnabledState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBlockPublicAccessState())
        .map(value =>
          zio.aws.ec2.model.ImageBlockPublicAccessEnabledState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse
  ): zio.aws.ec2.model.EnableImageBlockPublicAccessResponse.ReadOnly =
    new Wrapper(impl)
}
