package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Ec2InstanceConnectEndpointState {
  def unwrap: software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState
}
object Ec2InstanceConnectEndpointState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState
  ): zio.aws.ec2.model.Ec2InstanceConnectEndpointState = value match {
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_IN_PROGRESS =>
      val r = `create-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_COMPLETE =>
      val r = `create-complete`
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_FAILED =>
      val r = `create-failed`
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_IN_PROGRESS =>
      val r = `delete-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_COMPLETE =>
      val r = `delete-complete`
      r
    case software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_FAILED =>
      val r = `delete-failed`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.UNKNOWN_TO_SDK_VERSION
  }
  case object `create-in-progress`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_IN_PROGRESS
  }
  case object `create-complete`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_COMPLETE
  }
  case object `create-failed`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.CREATE_FAILED
  }
  case object `delete-in-progress`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_IN_PROGRESS
  }
  case object `delete-complete`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_COMPLETE
  }
  case object `delete-failed`
      extends zio.aws.ec2.model.Ec2InstanceConnectEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState =
      software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpointState.DELETE_FAILED
  }
}
