package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamResourceDiscoveryAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateIpamResourceDiscoveryRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamResourceDiscoveryAssociationId: IpamResourceDiscoveryAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest = {
    import DisassociateIpamResourceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamResourceDiscoveryAssociationId(
        IpamResourceDiscoveryAssociationId.unwrap(
          ipamResourceDiscoveryAssociationId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest
      .wrap(buildAwsValue())
}
object DisassociateIpamResourceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest =
      zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest(
        dryRun.map(value => value),
        ipamResourceDiscoveryAssociationId
      )
    def dryRun: Optional[Boolean]
    def ipamResourceDiscoveryAssociationId: IpamResourceDiscoveryAssociationId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamResourceDiscoveryAssociationId
        : ZIO[Any, Nothing, IpamResourceDiscoveryAssociationId] =
      ZIO.succeed(ipamResourceDiscoveryAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ) extends zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamResourceDiscoveryAssociationId
        : IpamResourceDiscoveryAssociationId =
      zio.aws.ec2.model.primitives.IpamResourceDiscoveryAssociationId(
        impl.ipamResourceDiscoveryAssociationId()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest
  ): zio.aws.ec2.model.DisassociateIpamResourceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
