package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateInstanceEventWindowRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceEventWindowId: InstanceEventWindowId,
    associationTarget: zio.aws.ec2.model.InstanceEventWindowDisassociationRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest = {
    import DisassociateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .associationTarget(associationTarget.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateInstanceEventWindowRequest
      .wrap(buildAwsValue())
}
object DisassociateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateInstanceEventWindowRequest =
      zio.aws.ec2.model.DisassociateInstanceEventWindowRequest(
        dryRun.map(value => value),
        instanceEventWindowId,
        associationTarget.asEditable
      )
    def dryRun: Optional[Boolean]
    def instanceEventWindowId: InstanceEventWindowId
    def associationTarget
        : zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getAssociationTarget: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly
    ] = ZIO.succeed(associationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val associationTarget
        : zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly =
      zio.aws.ec2.model.InstanceEventWindowDisassociationRequest
        .wrap(impl.associationTarget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ): zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly =
    new Wrapper(impl)
}
