package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableImageBlockPublicAccessRequest(
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest = {
    import DisableImageBlockPublicAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableImageBlockPublicAccessRequest.ReadOnly =
    zio.aws.ec2.model.DisableImageBlockPublicAccessRequest.wrap(buildAwsValue())
}
object DisableImageBlockPublicAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableImageBlockPublicAccessRequest =
      zio.aws.ec2.model
        .DisableImageBlockPublicAccessRequest(dryRun.map(value => value))
    def dryRun: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest
  ) extends zio.aws.ec2.model.DisableImageBlockPublicAccessRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest
  ): zio.aws.ec2.model.DisableImageBlockPublicAccessRequest.ReadOnly =
    new Wrapper(impl)
}
