package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableAwsNetworkPerformanceMetricSubscriptionResponse(
    output: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse = {
    import DisableAwsNetworkPerformanceMetricSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse
      .builder()
      .optionallyWith(output.map(value => value: java.lang.Boolean))(_.output)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly =
    zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse
      .wrap(buildAwsValue())
}
object DisableAwsNetworkPerformanceMetricSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse =
      zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse(
        output.map(value => value)
      )
    def output: Optional[Boolean]
    def getOutput: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("output", output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse
  ) extends zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly {
    override val output: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse
  ): zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
