package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DeviceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.DeviceType
}
object DeviceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DeviceType
  ): zio.aws.ec2.model.DeviceType = value match {
    case software.amazon.awssdk.services.ec2.model.DeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DeviceType.EBS =>
      val r = ebs
      r
    case software.amazon.awssdk.services.ec2.model.DeviceType.INSTANCE_STORE =>
      val r = `instance-store`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DeviceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DeviceType =
      software.amazon.awssdk.services.ec2.model.DeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ebs extends zio.aws.ec2.model.DeviceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DeviceType =
      software.amazon.awssdk.services.ec2.model.DeviceType.EBS
  }
  case object `instance-store` extends zio.aws.ec2.model.DeviceType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DeviceType =
      software.amazon.awssdk.services.ec2.model.DeviceType.INSTANCE_STORE
  }
}
