package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  TrafficMirroringMaxResults,
  TrafficMirrorTargetId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorTargetsRequest(
    trafficMirrorTargetIds: Optional[Iterable[TrafficMirrorTargetId]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[TrafficMirroringMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest = {
    import DescribeTrafficMirrorTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest
      .builder()
      .optionallyWith(
        trafficMirrorTargetIds.map(value =>
          value.map { item =>
            TrafficMirrorTargetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trafficMirrorTargetIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          TrafficMirroringMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest.wrap(buildAwsValue())
}
object DescribeTrafficMirrorTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest =
      zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest(
        trafficMirrorTargetIds.map(value => value),
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trafficMirrorTargetIds: Optional[List[TrafficMirrorTargetId]]
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[TrafficMirroringMaxResults]
    def nextToken: Optional[NextToken]
    def getTrafficMirrorTargetIds
        : ZIO[Any, AwsError, List[TrafficMirrorTargetId]] = AwsError
      .unwrapOptionField("trafficMirrorTargetIds", trafficMirrorTargetIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TrafficMirroringMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest.ReadOnly {
    override val trafficMirrorTargetIds: Optional[List[TrafficMirrorTargetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorTargetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrafficMirrorTargetId(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[TrafficMirroringMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.TrafficMirroringMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest
  ): zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
