package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIpamResourceDiscoveriesResponse(
    ipamResourceDiscoveries: Optional[
      Iterable[zio.aws.ec2.model.IpamResourceDiscovery]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse = {
    import DescribeIpamResourceDiscoveriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse
      .builder()
      .optionallyWith(
        ipamResourceDiscoveries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamResourceDiscoveries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse
      .wrap(buildAwsValue())
}
object DescribeIpamResourceDiscoveriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse =
      zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse(
        ipamResourceDiscoveries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipamResourceDiscoveries
        : Optional[List[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getIpamResourceDiscoveries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipamResourceDiscoveries",
      ipamResourceDiscoveries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse
  ) extends zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse.ReadOnly {
    override val ipamResourceDiscoveries
        : Optional[List[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamResourceDiscovery.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse
  ): zio.aws.ec2.model.DescribeIpamResourceDiscoveriesResponse.ReadOnly =
    new Wrapper(impl)
}
