package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ImportSnapshotTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImportSnapshotTasksRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    importTaskIds: Optional[Iterable[ImportSnapshotTaskId]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest = {
    import DescribeImportSnapshotTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        importTaskIds.map(value =>
          value.map { item =>
            ImportSnapshotTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.importTaskIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeImportSnapshotTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImportSnapshotTasksRequest.wrap(buildAwsValue())
}
object DescribeImportSnapshotTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest =
      zio.aws.ec2.model.DescribeImportSnapshotTasksRequest(
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        importTaskIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def importTaskIds: Optional[List[ImportSnapshotTaskId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getImportTaskIds: ZIO[Any, AwsError, List[ImportSnapshotTaskId]] =
      AwsError.unwrapOptionField("importTaskIds", importTaskIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest
  ) extends zio.aws.ec2.model.DescribeImportSnapshotTasksRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val importTaskIds: Optional[List[ImportSnapshotTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ImportSnapshotTaskId(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest
  ): zio.aws.ec2.model.DescribeImportSnapshotTasksRequest.ReadOnly =
    new Wrapper(impl)
}
