package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeFpgaImagesMaxResults,
  NextToken,
  FpgaImageId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFpgaImagesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    fpgaImageIds: Optional[Iterable[FpgaImageId]] = Optional.Absent,
    owners: Optional[Iterable[String]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[DescribeFpgaImagesMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest = {
    import DescribeFpgaImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        fpgaImageIds.map(value =>
          value.map { item =>
            FpgaImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fpgaImageIds)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          DescribeFpgaImagesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFpgaImagesRequest.wrap(buildAwsValue())
}
object DescribeFpgaImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFpgaImagesRequest =
      zio.aws.ec2.model.DescribeFpgaImagesRequest(
        dryRun.map(value => value),
        fpgaImageIds.map(value => value),
        owners.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def fpgaImageIds: Optional[List[FpgaImageId]]
    def owners: Optional[List[String]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[DescribeFpgaImagesMaxResults]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFpgaImageIds: ZIO[Any, AwsError, List[FpgaImageId]] =
      AwsError.unwrapOptionField("fpgaImageIds", fpgaImageIds)
    def getOwners: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("owners", owners)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeFpgaImagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ) extends zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val fpgaImageIds: Optional[List[FpgaImageId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fpgaImageIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.FpgaImageId(item)
          }.toList
        )
    override val owners: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[DescribeFpgaImagesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeFpgaImagesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest
  ): zio.aws.ec2.model.DescribeFpgaImagesRequest.ReadOnly = new Wrapper(impl)
}
