package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConversionTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConversionTasksRequest(
    conversionTaskIds: Optional[Iterable[ConversionTaskId]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest = {
    import DescribeConversionTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
      .builder()
      .optionallyWith(
        conversionTaskIds.map(value =>
          value.map { item =>
            ConversionTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.conversionTaskIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeConversionTasksRequest.wrap(buildAwsValue())
}
object DescribeConversionTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeConversionTasksRequest =
      zio.aws.ec2.model.DescribeConversionTasksRequest(
        conversionTaskIds.map(value => value),
        dryRun.map(value => value)
      )
    def conversionTaskIds: Optional[List[ConversionTaskId]]
    def dryRun: Optional[Boolean]
    def getConversionTaskIds: ZIO[Any, AwsError, List[ConversionTaskId]] =
      AwsError.unwrapOptionField("conversionTaskIds", conversionTaskIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ) extends zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly {
    override val conversionTaskIds: Optional[List[ConversionTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversionTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ConversionTaskId(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ): zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
