package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeCapacityReservationFleetsMaxResults,
  CapacityReservationFleetId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationFleetsRequest(
    capacityReservationFleetIds: Optional[
      Iterable[CapacityReservationFleetId]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeCapacityReservationFleetsMaxResults] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest = {
    import DescribeCapacityReservationFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
      .builder()
      .optionallyWith(
        capacityReservationFleetIds.map(value =>
          value.map { item =>
            CapacityReservationFleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityReservationFleetIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCapacityReservationFleetsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
      .wrap(buildAwsValue())
}
object DescribeCapacityReservationFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest =
      zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest(
        capacityReservationFleetIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def capacityReservationFleetIds: Optional[List[CapacityReservationFleetId]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeCapacityReservationFleetsMaxResults]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getCapacityReservationFleetIds
        : ZIO[Any, AwsError, List[CapacityReservationFleetId]] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetIds",
        capacityReservationFleetIds
      )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeCapacityReservationFleetsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ) extends zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly {
    override val capacityReservationFleetIds
        : Optional[List[CapacityReservationFleetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationFleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.CapacityReservationFleetId(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[DescribeCapacityReservationFleetsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeCapacityReservationFleetsMaxResults(value)
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ): zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly =
    new Wrapper(impl)
}
