package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAccountAttributesRequest(
    attributeNames: Optional[Iterable[zio.aws.ec2.model.AccountAttributeName]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest = {
    import DescribeAccountAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
      .builder()
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAccountAttributesRequest.wrap(buildAwsValue())
}
object DescribeAccountAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAccountAttributesRequest =
      zio.aws.ec2.model.DescribeAccountAttributesRequest(
        attributeNames.map(value => value),
        dryRun.map(value => value)
      )
    def attributeNames: Optional[List[zio.aws.ec2.model.AccountAttributeName]]
    def dryRun: Optional[Boolean]
    def getAttributeNames
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AccountAttributeName]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ) extends zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly {
    override val attributeNames
        : Optional[List[zio.aws.ec2.model.AccountAttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AccountAttributeName.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ): zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
