package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpcRequest(
    vpcId: VpcId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcRequest = {
    import DeleteVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpcRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcRequest.wrap(buildAwsValue())
}
object DeleteVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcRequest =
      zio.aws.ec2.model.DeleteVpcRequest(vpcId, dryRun.map(value => value))
    def vpcId: VpcId
    def dryRun: Optional[Boolean]
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ) extends zio.aws.ec2.model.DeleteVpcRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ): zio.aws.ec2.model.DeleteVpcRequest.ReadOnly = new Wrapper(impl)
}
