package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteTableRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest = {
    import DeleteTransitGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest =
      zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest(
        transitGatewayRouteTableId,
        dryRun.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def dryRun: Optional[Boolean]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
