package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPrefixListReferenceResponse(
    transitGatewayPrefixListReference: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListReference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse = {
    import DeleteTransitGatewayPrefixListReferenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse
      .builder()
      .optionallyWith(
        transitGatewayPrefixListReference.map(value => value.buildAwsValue())
      )(_.transitGatewayPrefixListReference)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPrefixListReferenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse =
      zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse(
        transitGatewayPrefixListReference.map(value => value.asEditable)
      )
    def transitGatewayPrefixListReference
        : Optional[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    def getTransitGatewayPrefixListReference: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPrefixListReference",
      transitGatewayPrefixListReference
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly {
    override val transitGatewayPrefixListReference: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPrefixListReference())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly =
    new Wrapper(impl)
}
