package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorSessionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorSessionRequest(
    trafficMirrorSessionId: TrafficMirrorSessionId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest = {
    import DeleteTrafficMirrorSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
      .builder()
      .trafficMirrorSessionId(
        TrafficMirrorSessionId.unwrap(trafficMirrorSessionId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest(
        trafficMirrorSessionId,
        dryRun.map(value => value)
      )
    def trafficMirrorSessionId: TrafficMirrorSessionId
    def dryRun: Optional[Boolean]
    def getTrafficMirrorSessionId: ZIO[Any, Nothing, TrafficMirrorSessionId] =
      ZIO.succeed(trafficMirrorSessionId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly {
    override val trafficMirrorSessionId: TrafficMirrorSessionId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorSessionId(impl.trafficMirrorSessionId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
