package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.RouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRouteTableRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    routeTableId: RouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest = {
    import DeleteRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteRouteTableRequest.wrap(buildAwsValue())
}
object DeleteRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteRouteTableRequest =
      zio.aws.ec2.model
        .DeleteRouteTableRequest(dryRun.map(value => value), routeTableId)
    def dryRun: Optional[Boolean]
    def routeTableId: RouteTableId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ): zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly = new Wrapper(impl)
}
