package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAccessScopeAnalysisRequest(
    networkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest = {
    import DeleteNetworkInsightsAccessScopeAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
      .builder()
      .networkInsightsAccessScopeAnalysisId(
        NetworkInsightsAccessScopeAnalysisId.unwrap(
          networkInsightsAccessScopeAnalysisId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkInsightsAccessScopeAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest =
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest(
        networkInsightsAccessScopeAnalysisId,
        dryRun.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId
    def dryRun: Optional[Boolean]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeAnalysisId] =
      ZIO.succeed(networkInsightsAccessScopeAnalysisId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : NetworkInsightsAccessScopeAnalysisId =
      zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(
        impl.networkInsightsAccessScopeAnalysisId()
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
  ): zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
