package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRouteTableVpcAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteTableVpcAssociationRequest(
    localGatewayRouteTableVpcAssociationId: LocalGatewayRouteTableVpcAssociationId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest = {
    import DeleteLocalGatewayRouteTableVpcAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
      .builder()
      .localGatewayRouteTableVpcAssociationId(
        LocalGatewayRouteTableVpcAssociationId.unwrap(
          localGatewayRouteTableVpcAssociationId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteTableVpcAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest =
      zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest(
        localGatewayRouteTableVpcAssociationId,
        dryRun.map(value => value)
      )
    def localGatewayRouteTableVpcAssociationId
        : LocalGatewayRouteTableVpcAssociationId
    def dryRun: Optional[Boolean]
    def getLocalGatewayRouteTableVpcAssociationId
        : ZIO[Any, Nothing, LocalGatewayRouteTableVpcAssociationId] =
      ZIO.succeed(localGatewayRouteTableVpcAssociationId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest.ReadOnly {
    override val localGatewayRouteTableVpcAssociationId
        : LocalGatewayRouteTableVpcAssociationId =
      zio.aws.ec2.model.primitives.LocalGatewayRouteTableVpcAssociationId(
        impl.localGatewayRouteTableVpcAssociationId()
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
