package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  LocalGatewayRoutetableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteRequest(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    dryRun: Optional[Boolean] = Optional.Absent,
    destinationPrefixListId: Optional[PrefixListResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest = {
    import DeleteLocalGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest =
      zio.aws.ec2.model.DeleteLocalGatewayRouteRequest(
        destinationCidrBlock.map(value => value),
        localGatewayRouteTableId,
        dryRun.map(value => value),
        destinationPrefixListId.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def dryRun: Optional[Boolean]
    def destinationPrefixListId: Optional[PrefixListResourceId]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val destinationPrefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
