package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateVersionsResponseErrorItem(
    launchTemplateId: Optional[String] = Optional.Absent,
    launchTemplateName: Optional[String] = Optional.Absent,
    versionNumber: Optional[Long] = Optional.Absent,
    responseError: Optional[zio.aws.ec2.model.ResponseError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem = {
    import DeleteLaunchTemplateVersionsResponseErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .optionallyWith(versionNumber.map(value => value: java.lang.Long))(
        _.versionNumber
      )
      .optionallyWith(responseError.map(value => value.buildAwsValue()))(
        _.responseError
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
      .wrap(buildAwsValue())
}
object DeleteLaunchTemplateVersionsResponseErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem =
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versionNumber.map(value => value),
        responseError.map(value => value.asEditable)
      )
    def launchTemplateId: Optional[String]
    def launchTemplateName: Optional[String]
    def versionNumber: Optional[Long]
    def responseError: Optional[zio.aws.ec2.model.ResponseError.ReadOnly]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getResponseError
        : ZIO[Any, AwsError, zio.aws.ec2.model.ResponseError.ReadOnly] =
      AwsError.unwrapOptionField("responseError", responseError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly {
    override val launchTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateId())
      .map(value => value: String)
    override val launchTemplateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateName())
      .map(value => value: String)
    override val versionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value => value: Long)
    override val responseError
        : Optional[zio.aws.ec2.model.ResponseError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseError())
        .map(value => zio.aws.ec2.model.ResponseError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ): zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly =
    new Wrapper(impl)
}
