package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEgressOnlyInternetGatewayRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest = {
    import DeleteEgressOnlyInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .egressOnlyInternetGatewayId(
        EgressOnlyInternetGatewayId.unwrap(
          egressOnlyInternetGatewayId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest
      .wrap(buildAwsValue())
}
object DeleteEgressOnlyInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest =
      zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest(
        dryRun.map(value => value),
        egressOnlyInternetGatewayId
      )
    def dryRun: Optional[Boolean]
    def egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, Nothing, EgressOnlyInternetGatewayId] =
      ZIO.succeed(egressOnlyInternetGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ) extends zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val egressOnlyInternetGatewayId: EgressOnlyInternetGatewayId =
      zio.aws.ec2.model.primitives
        .EgressOnlyInternetGatewayId(impl.egressOnlyInternetGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ): zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
