package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SnapshotId,
  KmsKeyId,
  Integer,
  AvailabilityZoneName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVolumeRequest(
    availabilityZone: AvailabilityZoneName,
    encrypted: Optional[Boolean] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    size: Optional[Integer] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeType: Optional[zio.aws.ec2.model.VolumeType] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    multiAttachEnabled: Optional[Boolean] = Optional.Absent,
    throughput: Optional[Integer] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVolumeRequest = {
    import CreateVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
      .builder()
      .availabilityZone(
        AvailabilityZoneName.unwrap(availabilityZone): java.lang.String
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        multiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.multiAttachEnabled)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVolumeRequest.ReadOnly =
    zio.aws.ec2.model.CreateVolumeRequest.wrap(buildAwsValue())
}
object CreateVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVolumeRequest =
      zio.aws.ec2.model.CreateVolumeRequest(
        availabilityZone,
        encrypted.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        outpostArn.map(value => value),
        size.map(value => value),
        snapshotId.map(value => value),
        volumeType.map(value => value),
        dryRun.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAttachEnabled.map(value => value),
        throughput.map(value => value),
        clientToken.map(value => value)
      )
    def availabilityZone: AvailabilityZoneName
    def encrypted: Optional[Boolean]
    def iops: Optional[Integer]
    def kmsKeyId: Optional[KmsKeyId]
    def outpostArn: Optional[String]
    def size: Optional[Integer]
    def snapshotId: Optional[SnapshotId]
    def volumeType: Optional[zio.aws.ec2.model.VolumeType]
    def dryRun: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def multiAttachEnabled: Optional[Boolean]
    def throughput: Optional[Integer]
    def clientToken: Optional[String]
    def getAvailabilityZone: ZIO[Any, Nothing, AvailabilityZoneName] =
      ZIO.succeed(availabilityZone)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAttachEnabled", multiAttachEnabled)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ) extends zio.aws.ec2.model.CreateVolumeRequest.ReadOnly {
    override val availabilityZone: AvailabilityZoneName =
      zio.aws.ec2.model.primitives.AvailabilityZoneName(impl.availabilityZone())
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val multiAttachEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAttachEnabled())
      .map(value => value: Boolean)
    override val throughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => value: Integer)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVolumeRequest
  ): zio.aws.ec2.model.CreateVolumeRequest.ReadOnly = new Wrapper(impl)
}
