package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPrefixListReferenceRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    prefixListId: PrefixListResourceId,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    blackhole: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest = {
    import CreateTransitGatewayPrefixListReferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(blackhole.map(value => value: java.lang.Boolean))(
        _.blackhole
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPrefixListReferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest =
      zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest(
        transitGatewayRouteTableId,
        prefixListId,
        transitGatewayAttachmentId.map(value => value),
        blackhole.map(value => value),
        dryRun.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def prefixListId: PrefixListResourceId
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def blackhole: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getBlackhole: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blackhole", blackhole)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val blackhole: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blackhole())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
  ): zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest.ReadOnly =
    new Wrapper(impl)
}
