package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TaggableResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTagsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    resources: Iterable[TaggableResourceId],
    tags: Iterable[zio.aws.ec2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTagsRequest = {
    import CreateTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTagsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .resources(resources.map { item =>
        TaggableResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTagsRequest.ReadOnly =
    zio.aws.ec2.model.CreateTagsRequest.wrap(buildAwsValue())
}
object CreateTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTagsRequest =
      zio.aws.ec2.model.CreateTagsRequest(
        dryRun.map(value => value),
        resources,
        tags.map { item =>
          item.asEditable
        }
      )
    def dryRun: Optional[Boolean]
    def resources: List[TaggableResourceId]
    def tags: List[zio.aws.ec2.model.Tag.ReadOnly]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getResources: ZIO[Any, Nothing, List[TaggableResourceId]] =
      ZIO.succeed(resources)
    def getTags: ZIO[Any, Nothing, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTagsRequest
  ) extends zio.aws.ec2.model.CreateTagsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val resources: List[TaggableResourceId] = impl
      .resources()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.TaggableResourceId(item)
      }
      .toList
    override val tags: List[zio.aws.ec2.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.ec2.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTagsRequest
  ): zio.aws.ec2.model.CreateTagsRequest.ReadOnly = new Wrapper(impl)
}
